﻿using System.Configuration;
using org.owasp.appsensor;

namespace AppSensor2.configuration
{
    public class EventElement : ConfigurationElement
    {
        /// <summary>
        /// Reference name of the event as taken from AppSensor documentation e.g. ACE2
        /// </summary>
        [ConfigurationProperty("name", IsRequired = true)]
        public string Name
        {
            get { return (string)this["name"]; }
            set { this["name"] = value; }
        }

        /// <summary>
        /// How many of these events will trigger the action(s)
        /// </summary>
        [ConfigurationProperty("count", IsRequired = true)]
        public int Count
        {
            get { return (int)this["count"]; }
            set { this["count"] = value; }
        }

        /// <summary>
        /// The interval in minutes during which 'count' events must occur to trigger the action(s)
        /// </summary>
        [ConfigurationProperty("interval", IsRequired = true)]
        public int Interval
        {
            get { return (int)this["interval"]; }
            set { this["interval"] = value; }
        }

        /// <summary>
        /// Comma separated list of one or more actions to take for this event
        /// </summary>
        [ConfigurationProperty("actions", IsRequired = true)]
        public string Actions
        {
            get { return (string)this["actions"]; }
            set { this["actions"] = value; }
        }

        /// <summary>
        /// If one of the actions is to disable the component in question, the duration of the lockout
        /// </summary>
        [ConfigurationProperty("disablecomponentduration")]
        public int DisableComponentDuration
        {
            get { return (int)this["disablecomponentduration"]; }
            set { this["disablecomponentduration"] = value; }
        }

        /// <summary>
        /// The units for the disable component duration 
        /// </summary>
        [ConfigurationProperty("disablecomponenttimescale")]
        public TimeIncrement DisableComponentTimeScale
        {
            get { return (TimeIncrement)this["disablecomponenttimescale"]; }
            set { this["disablecomponenttimescale"] = value; }
        }

        /// <summary>
        /// If one of the action is to disable the component for the specific user, the duration of the lockout
        /// </summary>
        [ConfigurationProperty("disablecomponentforuserduration")]
        public int DisableComponentForUserDuration
        {
            get { return (int)this["disablecomponentforuserduration"]; }
            set { this["disablecomponentforuserduration"] = value; }
        }

        /// <summary>
        /// The units for the disable component for user duration
        /// </summary>
        [ConfigurationProperty("disablecomponentforusertimescale")]
        public TimeIncrement DisableComponentForUserTimeScale
        {
            get { return (TimeIncrement)this["disablecomponentforusertimescale"]; }
            set { this["disablecomponentforusertimescale"] = value; }
        }
    }

    public class EventElementCollection : ConfigurationElementCollection
    {
        public EventElement this[int index]
        {
            get { return (EventElement)BaseGet(index); }
            set
            {
                if (BaseGet(index) != null) { BaseRemoveAt(index); }
                BaseAdd(index, value);
            }
        }

        public new EventElement this[string key]
        {
            get { return (EventElement)BaseGet(key); }
        }

        protected override ConfigurationElement CreateNewElement()
        {
            return new EventElement();
        }

        protected override object GetElementKey(ConfigurationElement element)
        {
            return ((EventElement)element).Name;
        }
    }
}
